<?php
/**
 * Utility functions to optimize database calls and HTML generation
 */

/**
 * Get categories with count, cached for performance
 */
function getCategoriesWithCount($db) {
    static $categories = null;
    
    if ($categories === null) {
        $categories = $db->query("
            SELECT id, name, slug, (SELECT COUNT(*) FROM posts p WHERE p.category_id=c.id) as cnt 
            FROM categories c 
            ORDER BY 
                CASE WHEN name REGEXP '^[A-Za-z]' THEN 0 ELSE 1 END,
                name COLLATE utf8mb4_unicode_ci
        ")->fetchAll(PDO::FETCH_ASSOC);
    }
    
    return $categories;
}

/**
 * Generate category navigation HTML
 */
function generateCategoryNav($db, $current_cat_slug = '') {
    $cats = getCategoriesWithCount($db);
    
    if($cats){
        $html = '<table border=0 cellpadding=2 cellspacing=0 width=100%>';
        foreach($cats as $c){
            $active_class = ($c['slug'] === $current_cat_slug) ? ' style="font-weight:bold;"' : '';
            $html .= '<tr><td><font face=Verdana size=-1><a href="browse.php?cat='.htmlspecialchars($c['slug']).'"'.$active_class.'>'.htmlspecialchars($c['name']).'</a> ('.intval($c['cnt']).')</font></td></tr>';
        }
        $html .= '</table>';
        return $html;
    } else {
        return '<font face=Verdana size=-1>Нет категорий</font>';
    }
}

/**
 * Get all tags, cached for performance
 */
function getAllTags($db) {
    static $tags = null;
    
    if ($tags === null) {
        $tags = $db->query("SELECT name FROM tags ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);
    }
    
    return $tags;
}